<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

try {
	$Lottery = new \Plugin\Lottery\Lottery();
	$Lottery->setUserid($_SESSION['userid']);
	$stashCredits = $Lottery->getStashCredits();
	
	// ACTION SUBMIT
	if(check_value($_GET['action'])) {
		if($_GET['action'] == 'transfer' && $stashCredits >= 1) {
			try {
				$Lottery->transferCredits();
				$stashCredits = 0;
				message('success', lang('lottery_success_2', true));
			} catch(Exception $ex) {
				message('error', $ex->getMessage());
			}
		}
	}
	
	// LOTTERY
	echo '<div class="lottery-container">';
		echo '<div class="lottery-container-menu">';
			echo '<ul>';
				echo '<li><a href="'.__LOTTERY_HOME__.'">'.lang('lottery_menu_1', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'history/">'.lang('lottery_menu_2', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'stash/">'.lang('lottery_menu_3', true).'</a></li>';
				echo '<li><a href="'.__LOTTERY_HOME__.'results/">'.lang('lottery_menu_4', true).'</a></li>';
				echo '<li><a href="'.config('website_forum_link', true).'" target="_blank">'.lang('lottery_menu_5', true).'</a></li>';
			echo '</ul>';
		echo '</div>';
		echo '<div class="lottery-container-head"></div>';
		echo '<div class="lottery-container-content-stash">';
			echo langf('lottery_txt_3', array($stashCredits));
			echo '<br /><br /><a href="'.__LOTTERY_HOME__.'stash/action/transfer" class="btn btn-primary">'.lang('lottery_txt_7', true).'</a>';
		echo '</div>';
	echo '</div>';
	
} catch (Exception $ex) {
	message('error', $ex->getMessage());
}